#include <stdio.h>
#include <windows.h>
#include <Wincrypt.h>
#include <string.h>

#define BUFSIZE 1024
#define MD5LEN  16

//wyznacz MD5 pliku
void MD5(char *filename,char *);
//odszyfruj zawartosc pliku i zmodyfikuj go
void RC4(char *,char *);
void zamien(int *,int *);

int main(int argc, char *argv[])
{   
    char source[]="Project1.exe";
    char dest[]="Project.exe";
    char klucz[33];
    char MD5Baz[33];
    char MD5Baz2[33];
    
//aby nie podawac wprost wzorcowego klucza, by nie byl latwy do odnalezienia w pliku binarnym  
    klucz[0]=50; klucz[1]=50; klucz[2]=55; klucz[3]=49; klucz[4]=51; klucz[5]=56;
    klucz[6]=51; klucz[7]=53; klucz[8]=49; klucz[9]=51; klucz[10]=99; klucz[11]=56; klucz[12]=100; klucz[13]=51; klucz[14]=55;
    klucz[15]=55; klucz[16]=48; klucz[17]=54; klucz[18]=51; klucz[19]=56; klucz[20]=48; klucz[21]=55; klucz[22]=52; klucz[23]=97;
    klucz[24]=56; klucz[25]=49; klucz[26]=101; klucz[27]=101; klucz[28]=50; klucz[29]=51; klucz[30]=53; klucz[31]=99; klucz[32]=0;

//wyznaczamy MD5 pliku bazowego
    MD5(source,MD5Baz);
//jesli MD5 pliku bazowego rozni sie od wzorca, ktos musial zeedytowac plik bazowy
    if(strncmp(MD5Baz,klucz,33))
    {
      printf("Blad. Zedytowano nieedytowalny plik\nNie odszyfrujesz juz cennego pliku.\n");
      RC4(dest,MD5Baz);
      MD5(dest,MD5Baz2);
      return 1;
    }
    
//odszyfruj plik i zmodyfikuj plik
    RC4(dest,MD5Baz);
    MD5(dest,MD5Baz2);
    if(strncmp(MD5Baz2,klucz,33))
    {
      printf("Blad MD5. Zedytowano nieedytowalny plik\nNie odszyfrujesz juz cennego pliku.\n");                                 
      return 1;
    }
    return 0;
}

void zamien(int *x1,int *x2)
{
   int tmp=*x1;
   *x1=*x2;
   *x2=tmp;
}

void MD5(char *filename,char *MD5ofFile)
{
//zmodyfikowana funkcja ze strony 
//http://msdn.microsoft.com/en-us/library/aa382380%28v=VS.85%29.aspx     
     
    DWORD dwStatus = 0;
    BOOL bResult = FALSE;
    HCRYPTPROV hProv = 0;
    HCRYPTHASH hHash = 0;
    HANDLE hFile = NULL;
    BYTE rgbFile[BUFSIZE];
    DWORD cbRead = 0;
    BYTE rgbHash[MD5LEN];
    DWORD cbHash = 0;
    CHAR rgbDigits[] = "0123456789abcdef";
    //char MD5ofFile[33];

    // Copyright (c) Microsoft Corporation.  All rights reserved.
    // Logic to check usage goes here.

    hFile = CreateFile(filename,
        GENERIC_READ,
        FILE_SHARE_READ,
        NULL,
        OPEN_EXISTING,
        FILE_FLAG_SEQUENTIAL_SCAN,
        NULL);

    if (INVALID_HANDLE_VALUE == hFile)
    {
        dwStatus = GetLastError();
        printf("Error opening file %s\nError: %d\n", filename, 
            dwStatus); 
        return;
    }

    // Get handle to the crypto provider
    if (!CryptAcquireContext(&hProv,
        NULL,
        NULL,
        PROV_RSA_FULL,
        CRYPT_VERIFYCONTEXT))
    {
        dwStatus = GetLastError();
        printf("CryptAcquireContext failed: %d\n", dwStatus); 
        CloseHandle(hFile);
        return;
    }

    if (!CryptCreateHash(hProv, CALG_MD5, 0, 0, &hHash))
    {
        dwStatus = GetLastError();
        printf("CryptAcquireContext failed: %d\n", dwStatus); 
        CloseHandle(hFile);
        CryptReleaseContext(hProv, 0);
        return;
    }

    while (bResult = ReadFile(hFile, rgbFile, BUFSIZE, 
        &cbRead, NULL))
    {
        if (0 == cbRead)
        {
            break;
        }

        if (!CryptHashData(hHash, rgbFile, cbRead, 0))
        {
            dwStatus = GetLastError();
            printf("CryptHashData failed: %d\n", dwStatus); 
            CryptReleaseContext(hProv, 0);
            CryptDestroyHash(hHash);
            CloseHandle(hFile);
            return;
        }
    }

    if (!bResult)
    {
        dwStatus = GetLastError();
        printf("ReadFile failed: %d\n", dwStatus); 
        CryptReleaseContext(hProv, 0);
        CryptDestroyHash(hHash);
        CloseHandle(hFile);
        return;
    }

    cbHash = MD5LEN;
    if (CryptGetHashParam(hHash, HP_HASHVAL, rgbHash, &cbHash, 0))
    {
        for (DWORD i = 0; i < cbHash; i++)
        {
            MD5ofFile[2*i]=rgbDigits[rgbHash[i] >> 4];
            MD5ofFile[2*i+1]=rgbDigits[rgbHash[i] & 0xf];    
        }        
        MD5ofFile[2*cbHash]=0;
    }
    else
    {
        dwStatus = GetLastError();
        printf("CryptGetHashParam failed: %d\n", dwStatus); 
    }

    CryptDestroyHash(hHash);
    CryptReleaseContext(hProv, 0);
    CloseHandle(hFile);

    //return MD5ofFile;    
}


void RC4(char *source,char *pass)
{
     DWORD dwStatus = 0;
     BOOL bResult = FALSE;
     HANDLE hFile = NULL;
     BYTE rgbFile[BUFSIZE];
     DWORD cbRead = 0;
     DWORD bytes;
     
     char data;
     int t=0;
     int k=0;
     int S[256];
     int K[256];
     int sizePas=strlen(pass);
     int i=0,j=0;
     //wstepna inicjalizacja Skrzynki i Tablicy K
     for(i=0; i<=255; i++)
     {
       S[i]=i;      
       K[i]=pass[(i % sizePas)];
     }
     //Mieszanie Skrzynki
     for(i=0; i<=255; i++)
     {
       j=(j+S[i]+K[i])%256;
       zamien(&S[j],&S[i]);       
     }
     i=j=0;
     //otwarcie bazowego pliku
     hFile= CreateFile(source,
        GENERIC_READ,
        FILE_SHARE_READ,
        NULL,
        OPEN_EXISTING,
        FILE_FLAG_SEQUENTIAL_SCAN,
        NULL);

     if (INVALID_HANDLE_VALUE == hFile)
     {
        dwStatus = GetLastError();
        printf("Error opening file %s\nError: %d\n", source,dwStatus); 
        return;
     }
     
     //rozmiar pliku do odszyfrowania
     int fsize=GetFileSize(hFile,NULL);     
     //tablica przechowujaca odczytane dane
     char dest[fsize];              
     
     while (bResult = ReadFile(hFile, rgbFile, 1, &cbRead, NULL))
     {
                 if (!cbRead) break;   
                 i=(i+1)%256;
                 j=(j+S[i])%256;
                 zamien(&S[i],&S[j]);
                 t=(S[i]+S[j])%256;               
                 data=S[t]^(*rgbFile);
                 dest[k++]=data;
     }        

     CloseHandle(hFile);
     //otwarcie pliku do wprowadzenia odszyfrowanego kodu
     hFile= CreateFile(source,
        GENERIC_WRITE,
        FILE_SHARE_WRITE,
        NULL,
        CREATE_ALWAYS,
        FILE_FLAG_SEQUENTIAL_SCAN,
        NULL);
        
     if (INVALID_HANDLE_VALUE == hFile)
     {
        dwStatus = GetLastError();
        printf("Error opening file %s\nError: %d\n", source,dwStatus); 
        return;
     }
     
    for(i=0;i<fsize;i++)
    {     
      data=dest[i];    
      bytes=i+1;
      WriteFile(hFile,&data,1,&bytes,NULL);
     }
 
     CloseHandle(hFile);
}
